import os
import sys

# Add the project directory to the Python path
project_path = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, project_path)

from app import create_app, db
from app.models import User, Car, Tour, Booking, QuoteRequest, Contact  # Import all your models
from sqlalchemy import text

def reset_database():
    app = create_app()
    with app.app_context():
        try:
            # Disable foreign key checks
            db.session.execute(text('PRAGMA foreign_keys = OFF;'))
            
            # Drop all tables
            db.drop_all()
            
            # Recreate all tables
            db.create_all()
            
            # Re-enable foreign key checks
            db.session.execute(text('PRAGMA foreign_keys = ON;'))
            
            db.session.commit()
            print("Database reset successfully.")
            
            # Optionally, create an admin user
            admin = User(username="admin")
            admin.set_password("your_admin_password")  # Replace with a secure password
            db.session.add(admin)
            db.session.commit()
            print("Admin user created.")
            
        except Exception as e:
            db.session.rollback()
            print(f"An error occurred: {str(e)}")
        finally:
            db.session.close()

if __name__ == "__main__":
    reset_database()