from app import create_app, db
from app.models import User, TourParentCategory, TourSubCategory, Tour, TourType
from sqlalchemy.exc import SQLAlchemyError

import os
from sqlalchemy.exc import SQLAlchemyError
from app import create_app, db
from app.models import User, TourParentCategory, TourSubCategory, Tour, TourType

admin_password = os.environ.get('ADMIN_PASSWORD', 'default_password')

def populate_database():
    app = create_app()
    with app.app_context():
        try:
            # Create admin user
            admin = User(username='admin')
            admin.set_password(admin_password)
            db.session.add(admin)

            # Create parent categories
            nature = TourParentCategory(name='Economy')
            culture = TourParentCategory(name='Value')
            adventure = TourParentCategory(name='luxury')
            db.session.add_all([nature, culture, adventure])

            # Create subcategories
            hiking = TourSubCategory(name='Family', parent_category=nature)
            wildlife = TourSubCategory(name='Wildlife', parent_category=nature)
            historical = TourSubCategory(name='Historical', parent_category=culture)
            food = TourSubCategory(name='Food & Cuisine', parent_category=culture)
            trekking = TourSubCategory(name='Trekking', parent_category=adventure)
            water_sports = TourSubCategory(name='Water Sports', parent_category=adventure)
            db.session.add_all([hiking, wildlife, historical, food, trekking, water_sports])

            # Create sample tours
            tour1 = Tour(
                type=TourType.DAY_TOUR,
                title='Mountain Hiking Adventure',
                subtitle='Explore beautiful mountain trails',
                description='A day of hiking through scenic mountain paths.',
                itinerary='Start at base camp, hike to the summit, enjoy the view, return to base.',
                subcategory=hiking
            )

            tour2 = Tour(
                type=TourType.MULTI_DAY_TOUR,
                title='Historical City Tour',
                subtitle='Discover the rich history of our city',
                description='A three-day tour exploring historical landmarks and museums.',
                itinerary='Day 1: City center, Day 2: Old town, Day 3: Museums',
                subcategory=historical
            )

            tour3 = Tour(
                type=TourType.SPECIAL_TOUR,
                title='Culinary Delights',
                subtitle='Taste the best local cuisines',
                description='A special food tour featuring local restaurants and markets.',
                itinerary='Visit 5 restaurants and 2 local markets, with tastings at each stop.',
                subcategory=food
            )

            db.session.add_all([tour1, tour2, tour3])

            # Commit all changes
            db.session.commit()
            print("Database populated successfully!")
        except SQLAlchemyError as e:
            db.session.rollback()
            print(f"An error occurred: {str(e)}")

if __name__ == '__main__':
    populate_database()
