from flask_wtf import FlaskForm
from wtforms import StringField, TextAreaField, DateField, SubmitField, IntegerField,HiddenField, SelectField
from flask_wtf.file import FileField, FileAllowed
from wtforms.validators import DataRequired, Email, NumberRange

class ContactForm(FlaskForm):
    name = StringField('Name', validators=[DataRequired()])
    email = StringField('Email', validators=[DataRequired(), Email()])
    subject = StringField('Subject', validators=[DataRequired()])
    message = TextAreaField('Message', validators=[DataRequired()])
    submit = SubmitField('Send Message')

class BookingForm(FlaskForm):
    name = StringField('Name', validators=[DataRequired()])
    email = StringField('Email', validators=[DataRequired(), Email()])
    start_date = DateField('Start Date', validators=[DataRequired()])
    end_date = DateField('End Date', validators=[DataRequired()])
    car_id = IntegerField('Car ID')
    tour_id = IntegerField('Tour ID')
    submit = SubmitField('Submit Booking')

class RequestQuoteForm(FlaskForm):
    first_name = StringField('First Name', validators=[DataRequired()])
    last_name = StringField('Last Name', validators=[DataRequired()])
    num_adults = IntegerField('Number of Adults', validators=[DataRequired(), NumberRange(min=1)])
    num_children = IntegerField('Children', validators=[NumberRange(min=0)])
    date_from = DateField('From', validators=[DataRequired()], format='%Y-%m-%d')
    date_to = DateField('To', validators=[DataRequired()], format='%Y-%m-%d')
    country = StringField('Country', validators=[DataRequired()])
  
    email = StringField('Email Address', validators=[DataRequired(), Email()])
    phone = StringField('Phone Number', validators=[DataRequired()])
    message = TextAreaField('Message')
    car_id = HiddenField('Car ID')  
    tour_id = HiddenField('Tour ID')
    car_name = HiddenField('Car Name')  
    tour_name = HiddenField('Tour Name')  
    submit = SubmitField('Request A Tailored Solution')

