from app import create_app, db
from app.models import User
from werkzeug.security import generate_password_hash

app = create_app()

def add_admin_user():
    with app.app_context():
        # Check if admin user already exists
        admin = User.query.filter_by(username='admin').first()
        if admin:
            print("Admin user already exists.")
            return

        # Create new admin user
        new_admin = User(
            username='admin',
            password_hash=generate_password_hash('A08dc@506')
            # Add any other required fields here
        )

        # If there's a method to set admin status, use it here
        # For example: new_admin.set_admin()

        # Add to database
        db.session.add(new_admin)
        db.session.commit()

        print("Admin user has been added successfully.")

if __name__ == '__main__':
    add_admin_user()