"""Initial migration

Revision ID: ba4240a8baf1
Revises: 
Create Date: 2024-09-10 22:52:30.207247

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'ba4240a8baf1'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('blog',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=200), nullable=False),
    sa.Column('slug', sa.String(length=200), nullable=False),
    sa.Column('content', sa.Text(), nullable=False),
    sa.Column('feature_image', sa.String(length=200), nullable=True),
    sa.Column('gallery_image_1', sa.String(length=200), nullable=True),
    sa.Column('gallery_image_2', sa.String(length=200), nullable=True),
    sa.Column('gallery_image_3', sa.String(length=200), nullable=True),
    sa.Column('meta_description', sa.String(length=160), nullable=True),
    sa.Column('meta_keywords', sa.String(length=200), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('slug')
    )
    op.create_table('car',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('capacity', sa.Integer(), nullable=True),
    sa.Column('price_per_day', sa.Float(), nullable=True),
    sa.Column('image', sa.String(length=200), nullable=True),
    sa.Column('category', sa.Enum('CAR', 'LUXURY_CAR', 'VAN', 'BUS', name='vehiclecategory'), nullable=False),
    sa.Column('has_ac', sa.Boolean(), nullable=True),
    sa.Column('has_usb', sa.Boolean(), nullable=True),
    sa.Column('has_player', sa.Boolean(), nullable=True),
    sa.Column('has_bluetooth', sa.Boolean(), nullable=True),
    sa.Column('luggage_space', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('contact',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('email', sa.String(length=120), nullable=False),
    sa.Column('subject', sa.String(length=200), nullable=False),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('timestamp', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tour_parent_category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('slug', sa.String(length=100), nullable=False),
    sa.Column('display_in_menu', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name'),
    sa.UniqueConstraint('slug')
    )
    op.create_table('user',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(length=64), nullable=False),
    sa.Column('password_hash', sa.String(length=128), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('tour_sub_category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('slug', sa.String(length=100), nullable=False),
    sa.Column('parent_category_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['parent_category_id'], ['tour_parent_category.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tour',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type', sa.Enum('DAY_TOUR', 'MULTI_DAY_TOUR', 'SPECIAL_TOUR', name='tourtype'), nullable=False),
    sa.Column('title', sa.String(length=100), nullable=False),
    sa.Column('subtitle', sa.String(length=200), nullable=True),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('itinerary', sa.Text(), nullable=False),
    sa.Column('inclusions', sa.Text(), nullable=True),
    sa.Column('exclusions', sa.Text(), nullable=True),
    sa.Column('additional_info', sa.Text(), nullable=True),
    sa.Column('image', sa.String(length=200), nullable=True),
    sa.Column('views', sa.Integer(), nullable=True),
    sa.Column('subcategory_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['subcategory_id'], ['tour_sub_category.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('booking',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('customer_name', sa.String(length=100), nullable=False),
    sa.Column('customer_email', sa.String(length=120), nullable=False),
    sa.Column('start_date', sa.Date(), nullable=False),
    sa.Column('end_date', sa.Date(), nullable=False),
    sa.Column('car_id', sa.Integer(), nullable=True),
    sa.Column('tour_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['car_id'], ['car.id'], ),
    sa.ForeignKeyConstraint(['tour_id'], ['tour.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('quote_request',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('first_name', sa.String(length=64), nullable=False),
    sa.Column('last_name', sa.String(length=64), nullable=False),
    sa.Column('num_adults', sa.Integer(), nullable=False),
    sa.Column('num_children', sa.Integer(), nullable=True),
    sa.Column('date_from', sa.Date(), nullable=False),
    sa.Column('date_to', sa.Date(), nullable=False),
    sa.Column('country', sa.String(length=64), nullable=False),
    sa.Column('email', sa.String(length=120), nullable=False),
    sa.Column('phone', sa.String(length=20), nullable=False),
    sa.Column('message', sa.Text(), nullable=True),
    sa.Column('car_id', sa.Integer(), nullable=True),
    sa.Column('tour_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['car_id'], ['car.id'], ),
    sa.ForeignKeyConstraint(['tour_id'], ['tour.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('tour_day',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('tour_id', sa.Integer(), nullable=False),
    sa.Column('day_number', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=100), nullable=False),
    sa.Column('description', sa.Text(), nullable=False),
    sa.ForeignKeyConstraint(['tour_id'], ['tour.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tour_day')
    op.drop_table('quote_request')
    op.drop_table('booking')
    op.drop_table('tour')
    op.drop_table('tour_sub_category')
    op.drop_table('user')
    op.drop_table('tour_parent_category')
    op.drop_table('contact')
    op.drop_table('car')
    op.drop_table('blog')
    # ### end Alembic commands ###
