import os
from dotenv import load_dotenv
import logging

# Set up logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

# Load the .env file
load_dotenv()

basedir = os.path.abspath(os.path.dirname(__file__))

class Config:
    SECRET_KEY = os.environ.get('SECRET_KEY') or 'fallback-secret-key'
    
    # Fix for DATABASE_URL
    db_url = os.environ.get('DATABASE_URL')
    if db_url:
        # Remove any leading '=' or 'DATABASE_URL='
        db_url = db_url.lstrip('=').removeprefix('DATABASE_URL=')
    SQLALCHEMY_DATABASE_URI = db_url or 'postgresql://itinysaq_admin:Ami%40A08dc%40506@localhost/itinysaq_travel_bee'
    
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    WTF_CSRF_ENABLED = True
    UPLOAD_FOLDER = 'static/images'
    MAIL_SERVER = 'itint.site'
    MAIL_PORT = 465
    MAIL_USE_TLS = False
    MAIL_USE_SSL = True
    MAIL_USERNAME = os.environ.get('MAIL_USERNAME')
    MAIL_PASSWORD = os.environ.get('MAIL_PASSWORD')
    MAIL_DEFAULT_SENDER = os.environ.get('MAIL_DEFAULT_SENDER')

    @staticmethod
    def init_app(app):
        pass

# Log environment variables
logger.info("Environment variables loaded from .env:")
logger.info(f"SECRET_KEY: {'Set' if os.environ.get('SECRET_KEY') else 'Not set'}")
logger.info(f"DATABASE_URL: {Config.SQLALCHEMY_DATABASE_URI}")
logger.info(f"MAIL_USERNAME: {'Set' if os.environ.get('MAIL_USERNAME') else 'Not set'}")
logger.info(f"MAIL_PASSWORD: {'Set' if os.environ.get('MAIL_PASSWORD') else 'Not set'}")
logger.info(f"MAIL_DEFAULT_SENDER: {os.environ.get('MAIL_DEFAULT_SENDER') or 'Not set'}")

# Log other relevant information
logger.info(f"Current working directory: {os.getcwd()}")
logger.info(f"Base directory: {basedir}")